// SetOSDText.cpp : implementation file
//

#include "stdafx.h"
#include "MyOSDProperty.h"
#include "SetOSDText.h"
#include "afxdialogex.h"


// CSetOSDText dialog

IMPLEMENT_DYNAMIC(CSetOSDText, CDialogEx)

CSetOSDText::CSetOSDText(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSetOSDText::IDD, pParent)
	, m_nXOffset(5)
	, m_nYOffset(5)
	, m_nTextWidth(320)
	, m_nTextHeight(240)	
	, m_nTransparent(255)
	, m_nBorderWidth(0)
{
	m_pOSDAlphaBlender = NULL;

	m_clrFontColor = RGB( 255, 0, 0 );	

	m_clrBackgroundColor = RGB( 255, 255, 255 );

	m_clrBorderColor = RGB( 255, 0, 0 );

	m_strTypeString = "YUAN";

	m_strFontFamilyName = "Arial";

	m_nOSDLayer = 0;

	m_nFontStyle = 0;

	m_nFontSize = 24;

	m_pMyFont = NULL;

	m_nWeight = 0;

	m_bItalic = 0;

	m_bUnderline = 0;

    m_bStrikeOut = 0;
}

CSetOSDText::~CSetOSDText()
{
}

void CSetOSDText::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_TEXT_X_OFFSET, m_nXOffset);
	DDV_MinMaxInt(pDX, m_nXOffset, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_TEXT_Y_OFFSET, m_nYOffset);
	DDV_MinMaxInt(pDX, m_nYOffset, 0, 1080);
	DDX_Text(pDX, IDC_EDIT_TEXT_WIDTH, m_nTextWidth);
	DDV_MinMaxInt(pDX, m_nTextWidth, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_TEXT_HEIGHT, m_nTextHeight);
	DDV_MinMaxInt(pDX, m_nTextHeight, 0, 1080);	
	DDX_Control(pDX, IDC_COMBO_TEXT_OSD_LAYER, m_comboTextOSDLayer);
	DDX_Control(pDX, IDC_EDIT_TEXT_TYPE_STRING, m_editTypeString);
	DDX_Control(pDX, IDC_COMBO_TEXT_OSD_FONT_SIZE, m_comboFontSize);
	DDX_Text(pDX, IDC_EDIT_TEXT_TRANSPARENT, m_nTransparent);
	DDV_MinMaxInt(pDX, m_nTransparent, 0, 255);
	DDX_Text(pDX, IDC_EDIT_TEXT_BORDER_WIDTH, m_nBorderWidth);
	DDV_MinMaxInt(pDX, m_nBorderWidth, 0, 10);	
	DDX_Control(pDX, IDC_SC_FONT_COLOR, m_scFontColor);
	DDX_Control(pDX, IDC_SC_BACKGROUND_COLOR, m_scBackgroundColor);
	DDX_Control(pDX, IDC_SC_BORDER_COLOR, m_scBorderColor);
}


BEGIN_MESSAGE_MAP(CSetOSDText, CDialogEx)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDOK, &CSetOSDText::OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, &CSetOSDText::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_BTN_FONT_DLG, &CSetOSDText::OnBnClickedBtnFontDlg)	
	ON_STN_CLICKED(IDC_SC_FONT_COLOR, &CSetOSDText::OnClickedScFontColor)
	ON_STN_CLICKED(IDC_SC_BACKGROUND_COLOR, &CSetOSDText::OnClickedScBackgroundColor)
	ON_STN_CLICKED(IDC_SC_BORDER_COLOR, &CSetOSDText::OnClickedScBorderColor)
	ON_CBN_SELCHANGE(IDC_COMBO_TEXT_OSD_FONT_SIZE, &CSetOSDText::OnSelchangeComboTextOsdFontSize)
END_MESSAGE_MAP()


// CSetOSDText message handlers

BOOL CSetOSDText::OnInitDialog()
{
	CDialogEx::OnInitDialog();	

	// TODO: Add extra initialization here

	m_comboTextOSDLayer.ResetContent();

	m_comboFontSize.ResetContent();

	CString str;

	int i = 0;

	for ( i = 0 ; i < 16 ; i++ )
	{
		str.Format(_T("%d"),  i );

		m_comboTextOSDLayer.AddString( str );
	}

	for ( i = 8 ; i <= 72 ; i++ )
	{
		str.Format(_T("%d"),  i );

		m_comboFontSize.AddString( str );
	}

	m_comboTextOSDLayer.SetCurSel( 0 );

	m_comboFontSize.SetCurSel( 0 );

	m_editTypeString.SetWindowText( m_strTypeString );	

	m_scFontColor.SetBkColor( m_clrFontColor );

	m_scBackgroundColor.SetBkColor( m_clrBackgroundColor );

	m_scBorderColor.SetBkColor( m_clrBorderColor );

	m_editTypeString.SetTextColor( m_clrFontColor );

	m_editTypeString.SetBkColor( m_clrBackgroundColor );

	m_pMyFont = new CFont();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetOSDText::OnDestroy()
{
	if ( m_pMyFont != NULL )
	{
		delete m_pMyFont;

		m_pMyFont = NULL;
	}

	CDialogEx::OnDestroy();
}

void CSetOSDText::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );	

	int nIndex = m_comboFontSize.GetCurSel();

	m_editTypeString.GetWindowText( m_strTypeString );

	CString str;	

	m_comboFontSize.GetLBText( nIndex, str );

	m_nFontSize = atoi( str );
	 
	nIndex = m_comboTextOSDLayer.GetCurSel();	

	m_nOSDLayer = nIndex;

	WCHAR wszTypeString [ 256 ];

	WCHAR wszFontFamilyName [ 256 ];	

	BOOL bSetOSD = FALSE;

	Gdiplus::ARGB aFontColor = RGB2ARGB( m_clrFontColor );

	Gdiplus::ARGB aBackgroundColor = RGB2ARGB( m_clrBackgroundColor );

	Gdiplus::ARGB aBorderColor = RGB2ARGB( m_clrBorderColor );

	if ( m_pOSDAlphaBlender != NULL )
	{
		//AMESDK_OSD_SET_TEXT( m_pOSDAlphaBlender, 0, 100, 100, 0, 0, "yuan test", "Arial", 1, 72, 0xFFFF0000, 0xFFFFFFFF, 0xFFFF0000, 10, 255, 0, 0, 0);

		//AMESDK_OSD_SET_TEXT(  m_pOSDAlphaBlender, 0, 0, 0, 320, 240, "CH01", "Arial", 0, 48, 0xFFFF0000, 0xFFFFFFFF, 128, 0,  0, 0, 0, 0  );
		
		bSetOSD = AMESDK_OSD_SET_TEXT(	m_pOSDAlphaBlender, 
			
																			m_nOSDLayer,
														
																			m_nXOffset, 
														
																			m_nYOffset, 
														
																			m_nTextWidth, 
														
																			m_nTextHeight, 
														
																			m_strTypeString.GetBuffer( 256 ), 
														
																			m_strFontFamilyName.GetBuffer( 256 ),

																			m_nFontStyle, 
														
																			m_nFontSize, 
														
																			aFontColor, 
														
																			aBackgroundColor, 
														
																			aBorderColor, 
														
																			m_nBorderWidth, 
														
																			m_nTransparent, 
														
																			0,
														
																			0,
														
																			0 );

		m_strTypeString.ReleaseBuffer();

		m_strFontFamilyName.ReleaseBuffer();		

		// SUPPORT WIDE CHARACTER STRING
		//
		 //USES_CONVERSION;

		 //int size1 = MultiByteToWideChar(CP_ACP, 0, m_strTypeString, -1, NULL, 0);

		 //wchar_t *pWStr1 = new wchar_t[ size1 + 1 ];

		 //MultiByteToWideChar(CP_ACP, 0, m_strTypeString, -1, pWStr1, size1);

		  //int size2 = MultiByteToWideChar(CP_ACP, 0, m_strFontFamilyName, -1, NULL, 0);

		 //wchar_t *pWStr2 = new wchar_t[ size2 + 1 ];

		 //MultiByteToWideChar(CP_ACP, 0, m_strFontFamilyName, -1, pWStr2, size2);

		 //wcscpy(wszTypeString,  CT2CW( m_strTypeString ));

		 //wcscpy(wszFontFamilyName,  CT2CW( m_strFontFamilyName ));		 

		 //bSetOSD = AMESDK_OSD_SET_TEXT_W(  m_pOSDAlphaBlender, 
			
		//																		 m_nOSDLayer,
														
		//																		 m_nXOffset, 
														
		//																		 m_nYOffset, 
														
		//																		 m_nTextWidth, 
														
		//																		 m_nTextHeight, 
														
		//																		 wszTypeString,
														
		//																		 wszFontFamilyName,

		//																		 m_nFontStyle, 
														
		//																		 m_nFontSize, 
														
		//																		 m_clrFontColor, 
														
		//																		 m_clrBackgroundColor, 
														
		//																		 m_clrBorderColor, 
														
		//																		 m_nBorderWidth, 
														
		//																		 m_nTransparent, 
														
		//																		 0,
														
		//																		 0,
														
		//																		 0 );
	}

	// GET OSD TEXT BOUNDARY
	//
	BOOL bGetOSD = FALSE;

	ULONG nBoundaryWidth = 0;

	ULONG nBoundaryHeight = 0;

	if ( m_pOSDAlphaBlender != NULL )
	{
		bGetOSD = AMESDK_OSD_GET_TEXT_BOUNDARY(  m_pOSDAlphaBlender, 
			
																								    m_nOSDLayer, 
																									
																									m_strTypeString.GetBuffer( 256 ), 
																									
																									m_strFontFamilyName.GetBuffer( 256 ), 
																									
																									m_nFontStyle, 
																									
																									m_nFontSize, 
																									
																									&nBoundaryWidth, 
																									
																									&nBoundaryHeight );

		m_strTypeString.ReleaseBuffer();

		m_strFontFamilyName.ReleaseBuffer();

		// SUPPORT WIDE CHARACTER STRING
		//		
		//bGetOSD = AMESDK_OSD_GET_TEXT_BOUNDARY_W(  m_pOSDAlphaBlender, 
			
		//																								m_nOSDLayer, 
																									
		//																								wszTypeString, 
																									
		//																								wszFontFamilyName, 
																									
		//																								m_nFontStyle, 
																									
		//																								m_nFontSize, 
																									
		//																								&nBoundaryWidth, 
																									
		//																								&nBoundaryHeight );		
	}

	//CDialogEx::OnOK();
}


void CSetOSDText::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here

	CDialogEx::OnCancel();
}


void CSetOSDText::OnBnClickedBtnFontDlg()
{
	// TODO: Add your control notification handler code here

	if ( m_pMyFont != NULL )
	{
		delete m_pMyFont;

		m_pMyFont = NULL;
	}

	CFontDialog fontDlg;	

	m_pMyFont= new CFont();	

	if ( fontDlg.DoModal() == IDOK )
	{
		LOGFONT logFont;

		fontDlg.GetCurrentFont( &logFont );

		if ( logFont.lfWeight == FW_REGULAR )
		{
			m_nFontStyle |= FONT_STYLE_REGULAR;

			m_nWeight = FW_REGULAR;
		}

		if ( logFont.lfWeight == FW_BOLD )
		{
			m_nFontStyle |= FONT_STYLE_BOLD;

			m_nWeight = FW_BOLD;
		}

		if ( logFont.lfItalic)
		{
			m_nFontStyle |= FONT_STYLE_ITALIC;

			m_bItalic = 1;
		}

		if ( logFont.lfUnderline)
		{
			m_nFontStyle |= FONT_STYLE_UNDERLINE;

			m_bUnderline = 1;
		}

		if ( logFont.lfStrikeOut)
		{
			m_nFontStyle |= FONT_STYLE_STRIKEOUT;

			m_bStrikeOut = 1;
		}    	

		m_strFontFamilyName.Format( "%s" ,  logFont.lfFaceName );		

		m_pMyFont->CreateFont(  logFont.lfHeight, 0, 0, 0, 
			
												   m_nWeight, 
												  
												   m_bItalic, 
												  
												   m_bUnderline, 
												  
												  m_bStrikeOut, 
			
												  ANSI_CHARSET, 
												
												  OUT_DEFAULT_PRECIS, 
												
												  CLIP_DEFAULT_PRECIS, 
												
												  DEFAULT_QUALITY, 
												
												  FIXED_PITCH | FF_MODERN,  
												
												  logFont.lfFaceName );		

		m_editTypeString.SetFont( m_pMyFont );
	}	
}


void CSetOSDText::OnClickedScFontColor()
{
	// TODO: Add your control notification handler code here

	CColorDialog clrDlg( m_clrFontColor );	

	if ( clrDlg.DoModal() == IDOK )
	{
		m_clrFontColor = clrDlg.GetColor();

		m_scFontColor.SetBkColor( m_clrFontColor );

		m_editTypeString.SetTextColor( m_clrFontColor );
	}
}


void CSetOSDText::OnClickedScBackgroundColor()
{
	// TODO: Add your control notification handler code here

	CColorDialog clrDlg( m_clrBackgroundColor );	

	if ( clrDlg.DoModal() == IDOK )
	{
		m_clrBackgroundColor = clrDlg.GetColor();

		m_scBackgroundColor.SetBkColor( m_clrBackgroundColor );

		m_editTypeString.SetBkColor( m_clrBackgroundColor );
	}
}


void CSetOSDText::OnClickedScBorderColor()
{
	// TODO: Add your control notification handler code here

	CColorDialog clrDlg( m_clrBorderColor );	

	if ( clrDlg.DoModal() == IDOK )
	{
		m_clrBorderColor = clrDlg.GetColor();

		m_scBorderColor.SetBkColor( m_clrBorderColor );
	}
}


void CSetOSDText::OnSelchangeComboTextOsdFontSize()
{
	// TODO: Add your control notification handler code here

	int nIndex = m_comboFontSize.GetCurSel();

	CString str;	

	m_comboFontSize.GetLBText( nIndex, str );

	m_nFontSize = atoi( str );

	LOGFONT lf;

	CFont * oldFont = m_editTypeString.GetFont();

	oldFont->GetLogFont( &lf );

	CDC *pDC = m_editTypeString.GetDC();	

	lf.lfHeight = -MulDiv( m_nFontSize, pDC->GetDeviceCaps(LOGPIXELSY), 72);	

	if ( m_pMyFont != NULL )
	{
		delete m_pMyFont;

		m_pMyFont = NULL;
	}

	CFontDialog fontDlg;	

	m_pMyFont= new CFont();	

	m_pMyFont->CreateFont(	lf.lfHeight, 0, 0, 0,
		
												m_nWeight, 
												
												m_bItalic, 
												
												m_bUnderline, 
												
												m_bStrikeOut,  
												
												ANSI_CHARSET, 
												
												OUT_DEFAULT_PRECIS, 
												
												CLIP_DEFAULT_PRECIS, 
												
												DEFAULT_QUALITY, 
												
												FIXED_PITCH | FF_MODERN, 
												
												m_strFontFamilyName );		

	m_editTypeString.SetFont( m_pMyFont );	
}
